<?php

defined('UNLIMITED_ELEMENTS_INC') or die('Restricted access');

class UCEmptyTemplate{
	
	const SHOW_DEBUG = false;
	
	private $templateID;
	private $isMultiple = false;
	
	
	
	/**
	 * construct
	 */
	public function __construct(){
		$this->init();
	}
	
	/** 
	 * put error message
	 */
	private function putErrorMessage($message = null){
		
		if(self::SHOW_DEBUG == true)
			dmp($message);
		
		dmp("no output");
		
	}
	
	/**
	 * render header debug
	 */
	private function renderHeader(){
		?>
		<header class="site-header">
			<p class="site-title">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
					<?php bloginfo( 'name' ); ?>
				</a>
			</p>
			<p class="site-description"><?php bloginfo( 'description' ); ?></p>
		</header>
		<?php 
	}
	
	/**
	 * render regular post body
	 */
	private function renderRegularBody(){
		
  	$this->renderHeader();
  	
	if ( have_posts() ) :
			
				while ( have_posts() ) :
			
					the_post();
					the_content();
					
				endwhile;
		endif;
	}
	
	/**
	 * validate that template exists
	 */
	private function validateTemplateExists(){
		
		if(empty($this->templateID))
			UniteFunctionsUC::throwError("no template found");
		
		$template = get_post($this->templateID);
		if(empty($template))	
			UniteFunctionsUC::throwError("template not found");
		
		$postType = $template->post_type;
		
		if($postType != "elementor_library")
			UniteFunctionsUC::throwError("bad template");
			
	}
	
	/**
	 * render header part
	 */
	private function renderHeaderPart(){
		?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
  <head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
    
    <style>
    html{
    	margin:0px !important;
    	padding:0px !important;
    }
    
    </style>
        
  </head>
  <body <?php body_class(); ?>>
		
		<?php 
	}
	
	/**
	 * render footer part
	 */
	private function renderFooter(){
		
		?>
		<!-- Start Footer! -->
		<?php 
				
		
		wp_footer();
				
		?>
			</body>
		</html>
		<?php 
	}
	
	/**
	 * render template
	 */
	private function renderTemplate(){

		if(is_singular() == false)
			UniteFunctionsUC::throwError("not singlular");
		
		UniteFunctionsUC::validateNumeric($this->templateID,"template id");
		
		$this->validateTemplateExists();
		
		$content = HelperProviderCoreUC_EL::getElementorTemplate($this->templateID, true);
		
		$this->renderHeaderPart();
		
		//$this->renderRegularBody();
		
		echo $content;
		
		$this->renderFooter();
		
}

	/**
	 * check and output debug
	 */
	private function checkOutputDebug(){
		
		$isDebug = UniteFunctionsUC::getGetVar("framedebug","",UniteFunctionsUC::SANITIZE_TEXT_FIELD);
		$isDebug = UniteFunctionsUC::strToBool($isDebug);
		
		if($isDebug == false)
			return(false);

		?>
		
		<style>
		
			.uc-debug-holder{
				display:flex;
				justify-content:center;
				padding:10px;
			}
			
			.uc-debug-holder button{
				margin-left:20px;
			}
			
			.uc-template-index{
				position:absolute;
				top:10px;
				left:10px;
			}
			
		</style>
		
		<div class="uc-debug-holder">
			
			<div id="debug_index" class="uc-template-index"></div>
			
			<button id="debug_button_prev">Prev</button>
			
			<button id="debug_button_next">Next</button>
			
		</div>
		
		
		<script>
		
			function trace(str){
				console.log(str);
			}

			jQuery(document).ready(function(){

				function setTemplateIndex(){

					var total = jQuery(".uc-template-holder").length;

					var active = jQuery(".uc-template-holder").not(".uc-template-hidden").index();

					active++;
					
					var text = active + " / " + total;
					
					jQuery("#debug_index").html(text);
					
				}
				
				
				//set some item active
				function setActive(dir){
					
					var objActiveTemplate = jQuery(".uc-template-holder").not(".uc-template-hidden");
					
					if(objActiveTemplate.length != 1){
						
						trace(objActiveTemplate);
						throw new Error("Wrong active template");
					}

					if(dir == "prev")					
						var objNextTemplate = objActiveTemplate.prev();
					else
						var objNextTemplate = objActiveTemplate.next();

					if(objNextTemplate.length == 0)
						return(false);
					
					objActiveTemplate.hide().addClass("uc-template-hidden");

					objNextTemplate.show().removeClass("uc-template-hidden");

					
					//clone the template tag
					
					var nextTemplateElement = objNextTemplate.children("template");

					if(nextTemplateElement.length){
						
						objNextTemplate.removeClass("uc-not-inited");

			            if(objNextTemplate.length > 1){
				            
				            trace(objNextTemplate);
				            throw new Error("wrong next template");
				            
				        }

			        	    
				        var clonedContent = nextTemplateElement[0].content.cloneNode(true);
				        objNextTemplate.append(clonedContent);
				      	
				        nextTemplateElement.remove();
				        
						setTimeout(function(){
					        
							jQuery("body").trigger("uc_dom_updated");
							
						}, 300);
						
					}

					setTemplateIndex();
				}

				jQuery("#debug_button_next").on("click",function(){

					setActive("next");
						
				});

				jQuery("#debug_button_prev").on("click",function(){

					setActive("prev");
						
				});

				setTemplateIndex();
				
			});
		
		</script>
		
		<?php 
		
		return(true);
	}
	
	
	
	
	/**
	 * render dynamic popup templates
	 */
	private function renderDynamicPopupTemplates(){
				
		$postIDs = UniteFunctionsUC::getGetVar("postids","",UniteFunctionsUC::SANITIZE_TEXT_FIELD);
		
		$isDebug = UniteFunctionsUC::getGetVar("debug","",UniteFunctionsUC::SANITIZE_TEXT_FIELD);
		$isDebug = UniteFunctionsUC::strToBool($isDebug);
		
		
		UniteFunctionsUC::validateNotEmpty($postIDs,"post ids");
		
		UniteFunctionsUC::validateIDsList($postIDs,"id's list");
		
		$arrPostIDs = explode(",",$postIDs);
		
		$templateID = $this->templateID;
				
		$content = "";
		
		foreach($arrPostIDs as $postID){
			
			HelperProviderCoreUC_EL::savePostForDynamic($postID);
			
			$urlTemplate = UniteFunctionsWPUC::getPermalink($templateID);
			
			//render in hidden mode
			
			$isHidden = false;
				
			GlobalsProviderUC::$renderTemplateID = $templateID;
			GlobalsProviderUC::$renderJSForHiddenContent = true;
			GlobalsProviderUC::$isInsideHiddenTemplate = true;
			
			$output = HelperProviderCoreUC_EL::getElementorTemplate($templateID, true);
			
			//set hidden content
			
			$class = "";

			$tag = "template";
			if($isDebug == true)
				$tag = "div";
						
			$output = "<{$tag} id='uc_template_output_{$templateID}_{$postID}' class='uc-template-output' data-postid='$postID' data-templateid='$templateID'>$output</{$tag}>\n";
			
			if(empty($output))
				$output = "template $templateID not found";
						
			GlobalsProviderUC::$renderJSForHiddenContent = false;
			GlobalsProviderUC::$isInsideHiddenTemplate = false;
			GlobalsProviderUC::$renderTemplateID = null;
			
			$content .= $output;
			
		}
				
		//don't know why, but it's not working. need to remove this dependency
		
		$this->renderHeaderPart();
		
		//check debug
				
		echo $content;
		
		$this->renderFooter();
				
	}
	
	/**
	 * render multiple template for templates widget output
	 */
	private function renderMultipleTemplates(){
		
		$this->isMultiple = true;
		
		$arrTemplates = explode(",", $this->templateID);
		
		UniteFunctionsUC::validateIDsList($this->templateID,"template ids");
		
		$content = "";
		
		foreach($arrTemplates as $index => $templateID){
			
			$urlTemplate = UniteFunctionsWPUC::getPermalink($templateID);
			
			//render in hidden mode
			
			$isHidden = false;
				
			GlobalsProviderUC::$renderTemplateID = $templateID;
			
			if($index > 0){
				
				GlobalsProviderUC::$renderJSForHiddenContent = true;
				$isHidden = true;
			}
			
			$output = HelperProviderCoreUC_EL::getElementorTemplate($templateID, true);
			
			//set hidden content
			
			$class = "";
			if($isHidden == true){
				
				$class = " uc-template-hidden uc-not-inited";
				
				$output = "\n\n<template>\n$output\n</template>\n\n";
			}
			
			if(empty($output))
				$output = "template $templateID not found";
			
			$urlTemplate = esc_attr($urlTemplate);
			
			$content .= "<div id='uc_template_$templateID' class='uc-template-holder{$class}' data-id='$templateID' data-link='$urlTemplate'>$output</div>";
			
			GlobalsProviderUC::$renderJSForHiddenContent = false;
			
			GlobalsProviderUC::$renderTemplateID = null;
			
		}
		
		//don't know why, but it's not working. need to remove this dependency
		
		UniteFunctionsWPUC::removeIncludeScriptDep("elementor-frontend");

		$this->renderHeaderPart();
		
		//check debug
		
		$isDebug = $this->checkOutputDebug();
		
		//$this->renderRegularBody();
		if($isDebug == true)
			echo "<div class='uc-debug-templates-wrapper'>";
		
		echo $content;
		
		if($isDebug == true)
			echo "</div>";
		
		
		$this->renderFooter();
		
	}
	
	
	/**
	 * init the template
	 */
	private function init(){
		
		try{
			
  			show_admin_bar(false);
			
			$renderTemplateID = UniteFunctionsUC::getGetVar("ucrendertemplate","",UniteFunctionsUC::SANITIZE_TEXT_FIELD);
			
			$isMultiple = UniteFunctionsUC::getGetVar("multiple","",UniteFunctionsUC::SANITIZE_TEXT_FIELD);
			$isMultiple = UniteFunctionsUC::strToBool($isMultiple);
			
			$isDynamicPopup = UniteFunctionsUC::getGetVar("dynamicpopup","",UniteFunctionsUC::SANITIZE_TEXT_FIELD);
			$isDynamicPopup = UniteFunctionsUC::strToBool($isDynamicPopup);
			
			$type = "single";
			if($isMultiple == true)
				$type = "multiple";
			else if ($isDynamicPopup == true)
				$type = "dynamic_popup";
			
			if(empty($renderTemplateID))
				UniteFunctionsUC::throwError("template id not found");
			
			$this->templateID = $renderTemplateID;
			
			switch($type){
				default:
				case "single":
					$this->renderTemplate();
				break;
				case "multiple":
					$this->renderMultipleTemplates();
				break;
				case "dynamic_popup":
					$this->renderDynamicPopupTemplates();
				break;
			}
						
			
		}catch(Exception $e){
			
			$message = $e->getMessage();
			
			$this->putErrorMessage($message);
			
		}
		
	}
	
}

new UCEmptyTemplate();